// Copyright (c) Caliper Corporation 2003.  All Rights Reserved
// Written by Peter Van Demark - Caliper Corporation - November 2002

    // This macro writes a text file with a list of formula fields and their
    // expressions for the current layer. The file is written to the C:\\temp folder.

    // The macro illustrates how to:
    // 1. Open, write to, and close a text file.
    // 2. Loop over an array.
    // 3. Get information about expressions.

    // You can modify the macro to use a dialog box to choose the name and folder 
    // for the output file, handle dataviews as well as layers, etc.

    // To run this macro using the GISDK toolbox:
    // 1. Open or choose the layer that you want to use.
    // 2. Choose Tools-Add-Ins and open the GIS Developer's Kit toolbox.
    // 3. Compile this macro in test mode using the first button (Compile).
    // 4. Run this macro by clicking the second button (Test), typing the macro 
    //    name "Write Formulas", clicking the Macro radio button, and clicking OK.

Macro "Write Formulas"

    // Get working layer and open text file in c:\temp folder
    layer = GetLayer()
    filehdl = OpenFile("C:\\temp\\"+layer+".exp", "w")

    // Write header with layer name, followed by blank line
    WriteLine(filehdl, layer)
    WriteLine(filehdl, null)

    // Get expressions (formula fields)
    expr = GetExpressions(layer)

    // For each write formula field name and expression, and blank line
    for i = 1 to expr.length do
        info = GetExpressionInfo(layer+'.'+expr[i])
        WriteLine(filehdl, expr[i]+" = "+info[4])
        WriteLine(filehdl, null)
        end

    // Close text file
    CloseFile(filehdl)

endMacro